/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.util.List;

public class SoftkeyParameter
extends ProtectionParameter {
    static final long serialVersionUID = -3138876231402046122L;
    private int blockSerializedDataVersion = 1;
    public static final boolean SWITCH = true;
    public static final boolean MOMENTARY = false;
    private static final boolean OFF = false;
    private static final boolean ON = true;
    private boolean fMode = true;
    private boolean fSwitchState;
    private transient boolean simulationSwitchState;
    private int fParCycle = 1;
    private transient int fCycle = 0;

    public SoftkeyParameter() {
    }

    public SoftkeyParameter(Block block) {
        super(block);
        this.fParameter = 1;
        this.fData = 1;
        this.fAllocatedTimer = 0;
    }

    public boolean calculateValue(boolean en) {
        boolean fSwitchStateOld = this.simulationSwitchState;
        if (this.simulationSwitchState) {
            this.fCycle = this.fParCycle;
            if (!this.fMode) {
                this.simulationSwitchState = false;
            }
        } else if (this.fMode) {
            this.fCycle = 0;
        }
        boolean result = false;
        if (en && this.fCycle > 0) {
            result = true;
        }
        if (!this.fMode && this.fCycle > 0) {
            --this.fCycle;
        }
        if (fSwitchStateOld != this.simulationSwitchState) {
            this.fireParameterUpdateEvent();
        }
        return result;
    }

    public int getAllocatedRAM() {
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence()) {
            return this.fData;
        }
        return 0;
    }

    public int getAllocatedREM() {
        if (this.getRemanenceAvailable() && this.getRemanenceObject().getRemanence()) {
            return this.fData;
        }
        return 0;
    }

    public String calculateCurrentParameterText() {
        return this.simulationSwitchState ? "On " : "Off";
    }

    public String getParameterText() {
        StringBuffer str = new StringBuffer(super.getParameterText());
        str.append("\n").append(this.isSwitch() ? "Switch" : "Momentary");
        if (this.isSwitch()) {
            str.append("=").append(this.isOn() ? "on" : "off");
        }
        if (this.getBlock().getWiringDiagram().getHardware().supports("softkeyProtection")) {
            str.append(this.getProtectionSign());
        }
        return str.toString();
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        boolean result = super.isAvailable(hardware, errorList);
        boolean supProtection = hardware.supports("softkeyProtection");
        if (this.getProtection() && !supProtection) {
            errorList.add(new ErrorInfo(this, "error.convert.protection", hardware));
            result = false;
        }
        return result;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.simulationSwitchState = this.fSwitchState;
            this.fCycle = 0;
        }
    }

    public boolean isOn() {
        return this.fSwitchState;
    }

    public boolean isSwitch() {
        return this.fMode;
    }

    public Boolean getSwitchState() {
        return this.fSwitchState;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fMode = dr.readBoolean();
        this.fSwitchState = dr.readBoolean();
        this.fParCycle = dr.readInt();
    }

    public void setMode(boolean newMode) {
        this.fMode = newMode;
    }

    public void setParCycle(int cyle) {
        this.fParCycle = cyle;
    }

    public void setSwitchState(Boolean newSwitchState) {
        this.fSwitchState = newSwitchState;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeBoolean(this.fMode);
        dw.writeBoolean(this.fSwitchState);
        dw.writeInt(this.fParCycle);
    }

    public int getParCycle() {
        return this.fParCycle;
    }

    public SwitchState getSimulationSwitchState() {
        return new SwitchState(this.simulationSwitchState);
    }

    public void setSimulationSwitchState(SwitchState state) {
        this.simulationSwitchState = state.getState();
    }

    public static class SwitchState {
        private boolean fState;

        public SwitchState(boolean state) {
            this.fState = state;
        }

        public boolean getState() {
            return this.fState;
        }

        public void setState(boolean state) {
            this.fState = state;
        }

        public String toString() {
            return this.fState ? "On " : "Off";
        }
    }
}

